# SDGNN for spatio-temporal setting

## Python environment setup with conda

```

conda create -n sdgnn python=3.9

conda activate sdgnn 

pip install torch==1.12.1+cu113 torchvision==0.13.1+cu113 torchaudio==0.12.1 --extra-index-url https://download.pytorch.org/whl/cu113 --trusted-host download.pytorch.org

pip install torch-scatter torch-sparse torch-cluster torch-spline-conv torch-geometric==2.2.0 -f https://data.pyg.org/whl/torch-1.12.1+cu113.html --trusted-host data.pyg.org

pip install rdkit

pip install torchmetrics==0.9.1

pip install opt_einsum

pip install pytorch-lightning 
```


## Dataset:

We provided the dataset you needed (PeMS04 and PeMS08) in a completed repo at 

We also provided a trianed target  model stored in the `./log/pem08_target` directory and a trained SDGNN stored in `./log/pem08_sdgnn`. 

Due to the space limit, the current repo does not contain the data. Please refer to the anonymized link for the complete data:

https://www.dropbox.com/scl/fo/jajy6cz65tmn3dwiednom/AJJ62n0OK3v1KXAB-aiLoyg?rlkey=uz4171xcrk5dqyn52bi01t9mo&st=mkprmz2s&dl=0

To simply train your own SDGNN please run 

```
python pem_sdgnn.py
```

To run the target model please run 
```
python -u pems.py --model GRUoGCN2x2 --source PeMS08 --target all --framework inductive --hidden 16 --activate softplus --epoch 1000 --lr 1e-3 --weight-decay 1e-5 --clipper value --patience 30 --seed 56 --device cuda:0
```

This two commands are also shown in `run.sh` file.


